/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Lightning
**
** DESCRIPTION:	Lightning effect
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef LIGHTNING_H
#define LIGHTNING_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"
#include "ldwImage.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const unsigned int Lightning_c_uiMinTimeBetweenFlashes = 15000;
const unsigned int Lightning_c_uiMaxTimeBetweenFlashes = 40000;
const unsigned int Lightning_c_uiMinTimeBetweenRolls = 20000;
const unsigned int Lightning_c_uiChanceOfRoll = 30;
const unsigned int Lightning_c_uiRollFlashInterval = 50;
const unsigned int Lightning_c_uiRollLength = 150;
const ldwColor Lightning_c_sFlashColor = ldwColor(0xE0, 0xF0,0xFF, 0x7F);

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CLightning
{
private:

	//class data
	bool			m_bIsFlashing;
	bool			m_bIsRolling;
	unsigned int	m_uiNextFlashTime;
	unsigned int	m_uiLastRollTime;

	//class methods
	//setup
	public:		CLightning();
	public:		~CLightning();
	public:		void Reset(bool playSound = true);

	//process
	public:		void Update();
	public:		void Draw();

	//access
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CLightning		Lightning;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/